#include ".\gameobject.h"
#include ".\LD10.h"
#include ".\Level.h"



GameObject::GameObject() :
  m_SpeedX( 0.0f ),
  m_SpeedY( 0.0f ),
  m_AccX( 0.0f ),
  m_AccY( 0.0f ),
  m_Angle( 0.0f ),
  m_Texture( LD10::TEX_TIMEBOMB_8 ),
  m_Type( LD10::GO_TIMEBOMB ),
  m_LifeTime( 0.0f ),
  m_RemoveMe( false ),
  m_DispX( 0 ),
  m_DispY( 0 ),
  m_FractX( 0.0f ),
  m_FractY( 0.0f ),
  m_Number( 0 ),
  m_ObjIndex( 0 )
{
}



GameObject::~GameObject(void)
{
}



void GameObject::Render()
{

  if ( m_Type != LD10::GO_EXPLOSION_RING )
  {
    theApp.RenderTextureSectionRotated( m_DispX, m_DispY, theApp.m_TexSec[m_Texture], m_Angle );
  }
  if ( m_Type == LD10::GO_STEEL_DIAMOND )
  {
    if ( m_Number )
    {
      char    Temp[20];

      wsprintf( Temp, "%d", m_Number );

      DWORD   ColorNumber = 0xffffffff;
      DWORD   ColorBack = 0xff000000;
      theApp.Print( m_DispX - 1, m_DispY - 8, Temp, ColorBack );
      theApp.Print( m_DispX - 2, m_DispY - 8, Temp, ColorBack );
      theApp.Print( m_DispX - 3, m_DispY - 7, Temp, ColorBack );
      theApp.Print( m_DispX - 3, m_DispY - 9, Temp, ColorBack );
      theApp.Print( m_DispX - 4, m_DispY - 8, Temp, ColorBack );
      theApp.Print( m_DispX - 2, m_DispY - 8, Temp, ColorNumber );
      theApp.Print( m_DispX - 3, m_DispY - 8, Temp, ColorNumber );
    }
  }

}



void GameObject::RenderShadow()
{

  if ( m_Type != LD10::GO_EXPLOSION_RING )
  {
    theApp.RenderTextureSectionRotated( m_DispX + 5, m_DispY + 5, theApp.m_TexSec[m_Texture], m_Angle, 0x80000000 );
  }

}



void GameObject::RenderFX()
{

  if ( m_Type == LD10::GO_EXPLOSION_RING )
  {
    int   Width = (int)( m_LifeTime * 128.0f );
    theApp.RenderTextureSection( m_DispX - Width / 2, m_DispY - Width / 2, theApp.m_TexSec[m_Texture], 0x80c020c0, 0x80c020c0, 0x80c020c0, 0x80c020c0, Width, Width );
  }

}



void GameObject::Update( float ElapsedTime, Level& theLevel )
{

  switch ( m_Type )
  {
    case LD10::GO_TIMEBOMB:
      m_LifeTime += ElapsedTime;
      if ( m_LifeTime >= 5.0f )
      {
        m_Type = LD10::GO_EXPLOSION;
        m_LifeTime = 0.0f;
        m_Texture = LD10::TEX_EXPLOSION_1;

        GameObject*    pExplosionRing = theLevel.CreateObject( LD10::GO_EXPLOSION_RING );

        pExplosionRing->m_DispX = m_DispX;
        pExplosionRing->m_DispY = m_DispY;

        theApp.PlaySound( LD10::SOUND_EXPLOSION2 );
      }
      else
      {
        LD10::TextureTypes    NewTex = (LD10::TextureTypes)( LD10::TEX_TIMEBOMB_8 + (int)( m_LifeTime / ( 5.0f / 9.0f ) ) );

        if ( NewTex != m_Texture )
        {
          m_Texture = NewTex;
          theApp.PlaySound( LD10::SOUND_TIMEBOMB_BLEEP );
        }
      }
      break;
    case LD10::GO_BURNING_BOMB:
      m_LifeTime -= ElapsedTime;
      if ( m_LifeTime <= 0.0f )
      {
        m_Type = LD10::GO_EXPLOSION;
        m_LifeTime = 0.0f;
        m_Texture = LD10::TEX_EXPLOSION_1;

        GameObject*    pExplosionRing = theLevel.CreateObject( LD10::GO_EXPLOSION_RING );

        pExplosionRing->m_DispX = m_DispX;
        pExplosionRing->m_DispY = m_DispY;

        theApp.PlaySound( LD10::SOUND_EXPLOSION );
      }
      break;
    case LD10::GO_EXPLOSION:
      m_LifeTime += ElapsedTime;
      if ( m_LifeTime >= 0.5f )
      {
        m_RemoveMe = true;
      }
      else
      {
        m_Texture = (LD10::TextureTypes)( LD10::TEX_EXPLOSION_1 + (int)( m_LifeTime / ( 0.5f / 4.0f ) ) );
      }
      break;
    case LD10::GO_EXPLOSION_RING:
      m_LifeTime += 3.0f * ElapsedTime;
      if ( m_LifeTime >= 1.0f )
      {
        m_RemoveMe = true;
      }
      break;
    case LD10::GO_TARGET_BALL:
    case LD10::GO_ROLLING_UNIT:
      if ( !theLevel.MoveObject( this, m_SpeedX * ElapsedTime, m_SpeedY * ElapsedTime ) )
      {
        theApp.PlaySound( LD10::SOUND_HITWALL );
      }
      break;
  }

}



void GameObject::UpdatePhysicsStep( Level& theLevel )
{

  switch ( m_Type )
  {
    case LD10::GO_TARGET_BALL:
    case LD10::GO_ROLLING_UNIT:
      m_SpeedX += m_AccX * 0.02f;
      m_SpeedY += m_AccY * 0.02f;
      m_AccX *= 0.8f;
      m_AccY *= 0.8f;
      m_SpeedX *= 0.99f;
      m_SpeedY *= 0.99f;
      break;
  }

}